@extends('layouts.main')

@section('title')
    App Settings
@endsection

@section('page-title')
    <div class="page-title">
        <div class="row">
            <div class="col-12 col-md-6 order-md-1 order-last">
                <h4>@yield('title')</h4>

            </div>
            <div class="col-12 col-md-6 order-md-2 order-first">

            </div>
        </div>
    </div>
@endsection

@section('content')
    <section class="section">

        <form class="form" action="{{ url('app-settings') }}" method="POST" enctype="multipart/form-data"
            data-parsley-validate>
            {{ csrf_field() }}
            <div class="row">
                <div class="col-md-6">

                    <div class="card">
                        <div class="card-body">
                            <div class="divider pt-3">
                                <h6 class="divider-text">{{ __('system_settings') }}</h6>

                            </div>
                            <label class="form-label  mt-3">{{ __('Splash Logo') }}</label>
                            <div class="row card h-100 d-flex">
                                <input class="filepond card col-md-12 bh-100" type="file" name="splash_logo"
                                    id="splash_logo">
                                <img src="{{ url('assets/images/logo/' . (system_setting('splash_logo') ? system_setting('splash_logo') : 'splash.svg')) }}"
                                    class="mt-2 splash_logo col-md-2" alt="image"
                                    style="height: 31%;width: 12%;background-color:rgb(180, 180, 180);margin-left:5px;"
                                    id="splash" accept=".svg" required>

                                <label class="form-label mt-3">{{ __('Home Screen Logo') }}</label>

                                <input class="filepond col-md-12" type="file" name="app_home_screen"
                                    id="app_home_screen">
                                <img src="{{ url('assets/images/logo/' . (system_setting('app_home_screen') ? system_setting('app_home_screen') : 'homeLogo.svg')) }}"
                                    class="mt-2 app_home_screen col-md-2" alt="image" style="height: 31%;width: 21%;">

                                <label class="form-label mt-3">{{ __('Placeholder Image') }}</label>

                                <input class="filepond col-md-12" type="file" name="placeholder_logo"
                                    id="placeholder_logo">
                                <img src="{{ url('assets/images/logo/' . (system_setting('placeholder_logo') ? system_setting('placeholder_logo') : 'placeholder.svg')) }}"
                                    class="mt-2 placeholder_logo col-md-2" alt="image" style="height: 31%;width: 15%;">
                            </div>
                        </div>
                    </div>

                </div>
                <div class="col-md-6">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="divider pt-3">
                                        <h6 class="divider-text">{{ __('More Settings') }}</h6>

                                    </div>
                                    <label class="col-sm-2 form-label-mandatory ">{{ __('IOS Version') }}</label>

                                    <div class="col-sm-12 form-group mandatory">
                                        <input name="ios_version" type="text" class="form-control"
                                            placeholder="App Version"
                                            value="{{ system_setting('ios_version') != '' ? system_setting('ios_version') : '' }}"
                                            data-parsley-required="true">
                                    </div>
                                    <label class="col-sm-12 form-label-mandatory ">{{ __('Android Version') }}</label>

                                    <div class="col-sm-12 form-group mandatory">
                                        <input name="android_version" type="text" class="form-control"
                                            placeholder="App Version"
                                            value="{{ system_setting('android_version') != '' ? system_setting('android_version') : '' }}"
                                            data-parsley-required="true">
                                    </div>
                                    <div class="form-check form-switch">
                                        <label class="form-check-label">{{ __('Force Update') }}</label>

                                        <input type="hidden" name="force_update" id="force_update"
                                            value="{{ system_setting('force_update') != '' ? system_setting('force_update') : 0 }}">
                                        <input class="form-check-input" type="checkbox" role="switch"
                                            {{ system_setting('force_update') == '1' ? 'checked' : '' }}
                                            id="switch_force_update">
                                        <label class="form-check-label mandatory" for="switch_force_update"></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="row">

                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="col-sm-12">
                                                <div class="divider pt-3">
                                                    <h6 class="divider-text">{{ __('Light Mode Colors') }}</h6>

                                                </div>
                                                <div class="row">

                                                    <div class="col-md-4">
                                                        <label class="form-label ">{{ __('Tertiary') }}</label>

                                                        <input name="light_tertiary" type="color" class="form-control"
                                                            placeholder="System Color"
                                                            value="{{ system_setting('light_tertiary') != '' ? system_setting('light_tertiary') : '#087C7C' }}"
                                                            id="systemColor">
                                                        <script>
                                                            // Initialize the color picker
                                                            new jscolor('.color', {
                                                                format: 'hex' // Set the format to hexadecimal
                                                            });
                                                        </script>

                                                    </div>

                                                    <div class="col-md-4">
                                                        <label class="form-label ">{{ __('Secondary') }}</label>

                                                        <input name="light_secondary" type="color" class="form-control"
                                                            placeholder="System Color"
                                                            value="{{ system_setting('light_secondary') != '' ? system_setting('light_secondary') : '#FFFFFF' }}"
                                                            id="systemColor">
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label ">{{ __('Primary') }}</label>

                                                        <input name="light_primary" type="color" class="form-control"
                                                            placeholder="System Color"
                                                            value="{{ system_setting('light_primary') != '' ? system_setting('light_primary') : '#FAFAFA' }}"
                                                            id="systemColor">
                                                    </div>
                                                </div>

                                            </div>
                                            <div class="col-sm-12 mt-1">

                                                <div class="divider pt-3">
                                                    <h6 class="divider-text">{{ __('Dark Mode Colors') }}</h6>

                                                </div>
                                                <div class="row">

                                                    <div class="col-md-4">
                                                        <label class="form-label ">{{ __('Tertiary') }}</label>

                                                        <input name="dark_tertiary" type="color" class="form-control"
                                                            placeholder="System Color"
                                                            value="{{ system_setting('dark_tertiary') != '' ? system_setting('dark_tertiary') : '#53ADAE' }}"
                                                            id="systemColor">
                                                    </div>

                                                    <div class="col-md-4">
                                                        <label class="form-label ">{{ __('Secondary') }}</label>

                                                        <input name="dark_secondary" type="color" class="form-control"
                                                            placeholder="System Color"
                                                            value="{{ system_setting('dark_secondary') != '' ? system_setting('dark_secondary') : '#1C1C1C' }}"
                                                            id="systemColor">
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label ">{{ __('Primary') }}</label>

                                                        <input name="dark_primary" type="color" class="form-control"
                                                            placeholder="System Color"
                                                            value="{{ system_setting('dark_primary') != '' ? system_setting('dark_primary') : '#0C0C0C' }}"
                                                            id="systemColor">
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="form-check form-switch">
                                        <label class="form-check-label">{{ __('Show Ad Mob Ads') }}</label>

                                        <input type="hidden" name="show_admob_ads" id="show_admob_ads"
                                            value="{{ system_setting('show_admob_ads') != '' ? system_setting('show_admob_ads') : 0 }}">
                                        <input class="form-check-input" type="checkbox" role="switch"
                                            {{ system_setting('show_admob_ads') == '1' ? 'checked' : '' }}
                                            id="switch_admob_ads">
                                        <label class="form-check-label mandatory" for="switch_admob_ads"></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-12" id="admobs">
                    <div class="card">
                        <div class="card-body">

                            <div id="admobs1">

                                <div class="divider pt-3">
                                    <h6 class="divider-text">{{ __('Banner Ad') }}</h6>

                                </div>

                                <div class="form-group mandatory row mt-3">

                                    <label class="col-sm-2 form-label-mandatory ">{{ _('Android') }}</label>

                                    <div class="col-sm-4 form-group mandatory">
                                        <input name="android_banner_ad_id" type="text" class="form-control"
                                            placeholder="Banner Ad Id" id="android_banner_ad_id"
                                            value="{{ system_setting('android_banner_ad_id') != '' ? system_setting('android_banner_ad_id') : '' }}"
                                            data-parsley-required="true">
                                    </div>
                                    <label class="col-sm-2 form-label-mandatory ">{{ __('IOS') }}</label>

                                    <div class="col-sm-4 form-group mandatory">
                                        <input name="ios_banner_ad_id" type="text" class="form-control"
                                            placeholder="Banner Ad Id" id="ios_banner_ad_id"
                                            value="{{ system_setting('ios_banner_ad_id') != '' ? system_setting('ios_banner_ad_id') : '' }}"
                                            data-parsley-required="true">
                                    </div>
                                </div>

                                <div class="divider pt-3">
                                    <h6 class="divider-text">{{ __('Interstitial Ad') }}</h6>

                                </div>

                                <div class="form-group mandatory row mt-3">

                                    <label class="col-sm-2 form-label-mandatory ">{{ _('Android') }}</label>

                                    <div class="col-sm-4 form-group mandatory">
                                        <input name="android_interstitial_ad_id" type="text" class="form-control"
                                            id='android_interstitial_ad_id' placeholder="Banner Ad Id"
                                            value="{{ system_setting('android_interstitial_ad_id') != '' ? system_setting('android_interstitial_ad_id') : '' }}">
                                    </div>
                                    <label class="col-sm-2 form-label-mandatory ">{{ __('IOS') }}</label>

                                    <div class="col-sm-4 form-group mandatory">
                                        <input name="ios_interstitial_ad_id" type="text" class="form-control"
                                            id="ios_interstitial_ad_id" placeholder="Interstitial Ad Id"
                                            value="{{ system_setting('ios_interstitial_ad_id') != '' ? system_setting('ios_interstitial_ad_id') : '' }}">
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 d-flex justify-content-end">
                <button type="submit" name="btnAdd1" value="btnAdd" id="btnAdd1"
                    class="btn btn-primary me-1 mb-1">Save</button>
            </div>

            </div>
        </form>

    </section>
@endsection
@section('script')
    <script>
        document.getElementById('splash').addEventListener('change', function() {
            console.log("change");
            const allowedExtensions = /(\.svg)$/i;
            const fileInput = this;
            const file = fileInput.files[0];

            if (!file) {
                return; // No file selected
            }

            if (!allowedExtensions.exec(file.name)) {
                alert("nooo");
                $('.img_error').text('Invalid file type. Please choose an image file.');
                fileInput.value = '';
                return;
            }

            const maxFileSize = 2 * 1024 * 1024; // 5MB (adjust as needed)
            if (file.size > maxFileSize) {
                $('.img_error').text('File size exceeds the maximum allowed size (2MB).');
                fileInput.value = '';
                return;
            }


        });


        $("#switch_force_update").on('change', function() {
            $("#switch_force_update").is(':checked') ? $("#force_update").val(1) : $("#force_update")
                .val(0);
        });
        $("#switch_admob_ads").on('change', function() {
            $("#switch_admob_ads").is(':checked') ? $("#show_admob_ads").val(1) : $("#show_admob_ads")
                .val(0);

            if ($("#switch_admob_ads").is(':checked')) {
                $('#admobs').show();
                $('#android_interstitial_banner_ad_id').attr('data-parsley-required', true);
                $('#ios_interstitial_banner_ad_id').attr('data-parsley-required', true);
                $('#android_banner_ad_id').attr('data-parsley-required', true);
                $('#ios_banner_ad_id').attr('data-parsley-required', true);


            } else {
                $('#admobs').hide();
                $('#android_interstitial_banner_ad_id').attr('data-parsley-required', false);
                $('#ios_interstitial_banner_ad_id').attr('data-parsley-required', false);
                $('#android_banner_ad_id').attr('data-parsley-required', false);
                $('#ios_banner_ad_id').attr('data-parsley-required', false);

            }
        });
        $(document).ready(function() {
            if ($("#switch_admob_ads").is(':checked')) {
                $('#admobs').show();

            } else {
                $('#admobs').hide();

            }
        });
    </script>
@endsection
